PROGRAM main_AHU
VAR
Supply_Damper_Opening_Delay_Timer		: TON ; 
Exhaust_Damper_Opening_Delay_Timer		: TON ; 
Supply_Fan_Conflict_Timer				: TON ;
Return_Fan_Conflict_Timer				: TON ;
Return_Air_PID							: PIDFB ;		(* CO2 meaurement to fan speed *)
Supply_Fan_PID							: PIDFB ;		(* active cooling to active heating *)
Return_Fan_PID							: PIDFB ;		(* return air temperature to supply PID setpoint *)
rTemp, rTemp2, rTemp3					: REAL ;
iTemp									: INT ;
AHU_status_old							: INT ;
Calculate_Heating_Valve_Position		: FB_heating_valve_position_calculation ;
supply_deviation_error_counter			: INT ;
END_VAR
(* Possible AHU statusses are:
		0	Stopped: Time schedule
		1	On: Time schedule
		
		5	Stopped: Supply Damper Open
		6	Stopped: Exhaust Damper Open
		7	Stopped: Supply Fan still running
		8	Stopped: Exhaust Fan still running
		
		10	Manual Off
		11	Manual On
		
		20	On: Opening dampers
		21	On: Fan startup
		
		101	Stopped: Supply Damper error
		102	Stopped: Exhaust Damper error
		103 Stopped: Supply fan error
		104	Stopped: Exhaust fan error
		105 Stopped: Heating coil return temperature too low
		
		110	Stopped: Fire alarm																*)

IF module_ready THEN
	(* prepare the timers ***************************************************************** *)
	Supply_Damper_Opening_Delay_Timer.PT		:=DINT_TO_TIME(1000*Damper_Opening_Delay);
	Exhaust_Damper_Opening_Delay_Timer.PT		:=DINT_TO_TIME(1000*Damper_Opening_Delay);
	Supply_Fan_Conflict_Timer.PT				:=DINT_TO_TIME(1000*Fan_Conflict_Delay);
	Return_Fan_Conflict_Timer.PT				:=DINT_TO_TIME(1000*Fan_Conflict_Delay);

	Supply_Damper_Opening_Delay_Timer	(); 
	Exhaust_Damper_Opening_Delay_Timer	();
	Supply_Fan_Conflict_Timer			();
	Return_Fan_Conflict_Timer			();
	
	(* prepare the PID's ****************************************************************** *)
	Return_Air_PID.measurement		:= Return_Air_CO2_Measurement ;
	Return_Air_PID.setpoint			:= Return_Air_CO2_Setpoint ;
	Return_Air_PID.stages 			:= 1; 				Return_Air_PID.balance 			:= 1; 
	Return_Air_PID.deadzone 		:= 5.0 ; 			Return_Air_PID.comfort 			:= 2.0 ;
	Return_Air_PID.min1 			:= iTemp ; 			Return_Air_PID.max1 			:= 100 ;			 
	Return_Air_PID.iTime 			:= 30 ; 			Return_Air_PID.dTime 			:= 0 ; 
	Return_Air_PID() ;

	Return_Fan_PID.measurement		:= Return_Air_Temperature_Measurement ;
	Return_Fan_PID.setpoint			:= Return_Air_Temperature_Setpoint ;
	Return_Fan_PID.stages 			:= 1; 				Return_Fan_PID.balance 			:= 0; 
	Return_Fan_PID.deadzone 		:= 0.5 ; 			Return_Fan_PID.comfort 			:= 0.2 ;
	Return_Fan_PID.min1 			:= 0 ; 				Return_Fan_PID.max1 			:= 100 ; 
	Return_Fan_PID.iTime 			:= 100 ; 			Return_Fan_PID.dTime 			:= 0 ; 
	Return_Fan_PID() ;

	Supply_Fan_PID.measurement		:= Supply_Air_Temperature_Measurement ;
	Supply_Fan_PID.setpoint			:= Supply_Air_Temperature_Calculated_Setpoint ;
	Supply_Fan_PID.stages 			:= 5; 				Supply_Fan_PID.balance 			:= 3; 
	Supply_Fan_PID.deadzone 		:= 0.5 ; 			Supply_Fan_PID.comfort 			:= 0.2 ;
	Supply_Fan_PID.min1 			:= 0 ; 				Supply_Fan_PID.max1 			:= 100 ; 
	Supply_Fan_PID.min2 			:= 0 ; 				Supply_Fan_PID.max2 			:= 100 ; 
	Supply_Fan_PID.min3 			:= 0 ; 				Supply_Fan_PID.max3 			:= 100 ;  
	Supply_Fan_PID.min4 			:= 0 ; 				Supply_Fan_PID.max4 			:= 100 ;  
	Supply_Fan_PID.min5 			:= 0 ; 				Supply_Fan_PID.max5 			:= 100 ;  
	Supply_Fan_PID.iTime 			:= 60 ; 			Supply_Fan_PID.dTime 			:= 0 ; 
	Supply_Fan_PID() ;	

	(* ************************************************************************************ *)
	(* first, we determine the AHU's current status *************************************** *)
	(* ************************************************************************************ *)
	IF AHU_status<100 THEN 
		AHU_status := Time_Schedule ;
		
		IF AHU_status=1 THEN																(* IF "On: Time schedule" *)

			(* supply temperature too much OFF ******************************************** *)
			IF Supply_Air_Temperature_Calculated_Setpoint<>0.0 THEN							(* might not be loaded yet the first itteration *)
				rTemp := ABS(Supply_Air_Temperature_Measurement-Supply_Air_Temperature_Calculated_Setpoint) ;
				IF rTemp>Supply_Air_Temperature_Setpoint_Deviation_Limit THEN				(* supply TE too high deviation *)
					supply_deviation_error_counter := supply_deviation_error_counter + 1 ;	(* start counting *)
					IF supply_deviation_error_counter>10 THEN
						AHU_status := 106 ;													(* Stopped: Supply temperature too much off setpoint *)
						Alarm_Reset := 1 ;													(* show the "reset alarm" button on the multiDISPLAY *)
					END_IF ;
				ELSE
					supply_deviation_error_counter := 0 ;									(* reset this counter *)				
				END_IF ;
			END_IF ;

			(* supply damper opening delay ************************************************ *)
			IF Fresh_Air_Damper_Position=OPENED THEN 										(* when the damper is open *)
				Supply_Damper_Opening_Delay_Timer.IN:=FALSE ;								(* stop the damper opening timer *)
			ELSE																			(* damper is not open *)
				Supply_Damper_Opening_Delay_Timer.IN:=TRUE;									(* start damper opening timer *)
				IF Supply_Damper_Opening_Delay_Timer.Q THEN									(* damper delay timer has run out *)
					AHU_status  := 101 ;													(* Stopped: Damper error *)
					Alarm_Reset := 1 ;														(* show the "reset alarm" button on the multiDISPLAY *)
				ELSE																		(* damper delay timer is running *)
					AHU_status := 20 ;														(* On: Opening dampers *)
				END_IF ;
			END_IF ;
			
			(* exhaust damper opening delay *********************************************** *)
			IF Exhaust_Air_Damper_Position=OPENED THEN 										(* when the damper is open *)
				Exhaust_Damper_Opening_Delay_Timer.IN:=FALSE ;								(* stop the damper opening timer *)
			ELSE																			(* damper is not open *)
				Exhaust_Damper_Opening_Delay_Timer.IN:=TRUE;								(* start damper opening timer *)
				IF Exhaust_Damper_Opening_Delay_Timer.Q THEN								(* damper delay timer has run out *)
					AHU_status  := 102 ;													(* Stopped: Damper error *)
					Alarm_Reset := 1 ;														(* show the "reset alarm" button on the multiDISPLAY *)
				ELSE																		(* damper delay timer is running *)
					AHU_status := 20 ;														(* On: Opening dampers *)
				END_IF ;
			END_IF ;
		
			(* supply fan conflict ******************************************************** *)
			IF Supply_Fan_Command=RUN THEN													(* supply fan should be running *)
				IF Supply_Fan_Status=NOT_RUNNING THEN										(* but no flow/feedback detected *)
					AHU_status := 21 ;														(* On: Fan startup *)
					Supply_Fan_Conflict_Timer.IN:=TRUE;										(* start the conflict timer *)
					IF Supply_Fan_Conflict_Timer.Q THEN										(* supply fan timer runs out *)
						AHU_status  := 103 ;												(* Stopped: Supply fan startup error *)
						Alarm_Reset := 1 ;													(* show the "reset alarm" button on the multiDISPLAY *)
					END_IF ;
				ELSE																		(* flow detected *)
					Supply_Fan_Conflict_Timer.IN:=FALSE;									(* reset timer *)
				END_IF ;
			ELSE
				Supply_Fan_Conflict_Timer.IN:=FALSE;										(* reset timer *)
			END_IF ;
	
			(* exhaust fan conflict ******************************************************* *)
			IF Return_Fan_Command=RUN THEN													(* exhaust fan should be running *)
				IF Return_Fan_Status=NOT_RUNNING THEN										(* but no flow/feedback detected *)
					AHU_status := 21 ;														(* On: Fan startup *)
					Return_Fan_Conflict_Timer.IN:=TRUE;										(* start the conflict timer *)
					IF Return_Fan_Conflict_Timer.Q THEN										(* exhaust fan timer runs out *)
						AHU_status  := 104 ;												(* Stopped: exhaust fan startup error *)
						Alarm_Reset := 1 ;													(* show the "reset alarm" button on the multiDISPLAY *)
					END_IF ;
				ELSE																		(* flow detected *)
					Return_Fan_Conflict_Timer.IN:=FALSE;									(* reset timer *)
				END_IF ;
			ELSE
				Return_Fan_Conflict_Timer.IN:=FALSE;										(* reset timer *)
			END_IF ;
			
		ELSIF AHU_status=0 OR (AHU_status>=5 AND AHU_status<=8) THEN						(* when the AHU is OFF, let's show it if dampers are open or fans still run *)
			supply_deviation_error_counter := 0 ;											(* reset this counter *)
			
			(* supply damper closing delay ************************************************ *)
			IF Fresh_Air_Damper_Position=OPENED THEN 										(* when the damper is still open *)
				Supply_Damper_Opening_Delay_Timer.IN:=TRUE ;								(* start damper timer *)
				IF Supply_Damper_Opening_Delay_Timer.Q THEN									(* damper delay timer has run out *)
					AHU_status  := 5 ;														(* Stopped: Damper conflict *)
				END_IF ;
			ELSE																			(* damper is not open; this is how it's supposed to be *)
				Supply_Damper_Opening_Delay_Timer.IN:=FALSE;								(* stop damper timer *)
			END_IF ;

			(* exhaust damper closing delay *********************************************** *)
			IF Exhaust_Air_Damper_Position=OPENED THEN 										(* when the damper is still open *)
				Exhaust_Damper_Opening_Delay_Timer.IN:=TRUE ;								(* start damper timer *)
				IF Exhaust_Damper_Opening_Delay_Timer.Q THEN								(* damper delay timer has run out *)
					AHU_status  := 6 ;														(* Stopped: Damper conflict *)
				END_IF ;
			ELSE																			(* damper is not open; this is how it's supposed to be *)
				Exhaust_Damper_Opening_Delay_Timer.IN:=FALSE;								(* stop damper timer *)
			END_IF ;

			(* supply fan conflict ******************************************************** *)
			IF Supply_Fan_Status=RUNNING THEN 												(* when the fan is still running *)
				Supply_Fan_Conflict_Timer.IN:=TRUE ;										(* start fan timer *)
				IF Supply_Fan_Conflict_Timer.Q THEN											(* fan stop delay timer has run out *)
					AHU_status  := 7 ;														(* Stopped: supply fan conflict *)
				END_IF ;
			ELSE																			(* fan is not running; this is how it's supposed to be *)
				Supply_Fan_Conflict_Timer.IN:=FALSE;										(* stop fan timer *)
			END_IF ;

			(* exhaust fan conflict ******************************************************* *)
			IF Return_Fan_Status=RUNNING THEN 												(* when the fan is still running *)
				Return_Fan_Conflict_Timer.IN:=TRUE ;										(* start fan timer *)
				IF Return_Fan_Conflict_Timer.Q THEN											(* fan delay timer has run out *)
					AHU_status  := 8 ;														(* Stopped: exhaust fan conflict *)
				END_IF ;
			ELSE																			(* fan is not running; this is how it's supposed to be *)
				Return_Fan_Conflict_Timer.IN:=FALSE;										(* stop damper timer *)
			END_IF ;
			
		END_IF ;																			(* we have now covered status 0, 1, and 5..8 *)
	ELSE																					(* AHU status >= 100 *)
		supply_deviation_error_counter := 0 ;												(* reset this counter *)

		IF Alarm_Reset=17 THEN																(* button was pushed on the display *)
			Alarm_Reset := 0 ;																(* reset the "reset alarm(s)" button *)
			AHU_Status	:= 0 ;																(* reset AHU status *)
		ELSIF AHU_Status<>AHU_status_old THEN												(* when the AHU_status is changed, so the instance an alarm is triggered *)
			Alarm_Reset := 1 ;																(* show the "reset alarm" button on the display *)
		END_IF ;
	END_IF;

	IF Manual_Operation_Control=1 THEN AHU_status:=11; END_IF ;								(* manual ON *)
	IF Manual_Operation_Control=2 THEN AHU_status:=10; END_IF ;								(* manual OFF *)
																							(* heating coil getting too cold *)
	IF Heating_Coil_Return_Water_Temperature_Measurement < Heating_Coil_Return_Water_Temperature_Alarm_Limit THEN AHU_status:=105; END_IF ;

	IF FireAlarm THEN AHU_status := 110; END_IF ;											(* Stopped: Fire alarm *)

	(* ************************************************************************************ *)
	(* Then, we set dampers, fans, etc. according the AHU status ************************** *)
	(* ************************************************************************************ *)
	IF AHU_status=0 OR (AHU_status>=5 AND AHU_status<=10) OR AHU_status>100 THEN			(* AHU stopped (according to TS), manually off, or in error *)
		Supply_Fan_Speed_Control		:= 0.0 ;											(* switch off all equipment *)
		Return_Fan_Speed_Control		:= 0.0 ;
		Supply_Fan_Command				:= STOP ;
		Return_Fan_Command				:= STOP ;
		HRU_Control						:= STOP ;
		HRU_Efficiency					:= 0.0 ;
		Fresh_Air_Damper_Control		:= CLOSE ;
		Exhaust_Air_Damper_Control		:= CLOSE ;
		
		Calculate_Heating_Valve_Position(PID_value:=0.0) ;									(* calculate heating coil valve position PID action is no relevant, so set to zero to disable *)
		Heating_Coil_Valve_Control 		:= Calculate_Heating_Valve_Position.Heating_Coil_Valve_Position ;
		Cooling_Coil_Valve_Control		:= 0.0 ;
		Cooling_Coil_Pump_Control		:= STOP ;
		
		Return_Air_PID.pband1			:= 0.0 ;											(* disable the PID's when they're not being used *)
		Return_Fan_PID.pband1			:= 0.0 ;
		Supply_Fan_PID.pband1			:= 0.0 ;
		Supply_Fan_PID.pband2			:= 0.0 ;
		Supply_Fan_PID.pband3			:= 0.0 ;
		Supply_Fan_PID.pband4			:= 0.0 ;
		Supply_Fan_PID.pband5			:= 0.0 ;
		
	ELSIF AHU_status=1 THEN																	(* ON time schedule *)
		(* if and when the machine is running, calculate PID's **************************************************************************************** *)
		Supply_Fan_Speed_Control 		:= Return_Air_PID.out1 ;
		Return_Fan_Speed_Control 		:= Return_Air_PID.out1 ;
		Supply_Fan_Command				:= RUN ;
		Return_Fan_Command				:= RUN ;

		(* Heat Recovery Unit control calculation ***************************************** *)
		rTemp := MAX(Supply_Fan_PID.out2, Supply_Fan_PID.out4) ;							(* stage2=HRU cooling, stage3=empty stage to delay HRU-cooling to HRU-heating change, stage4=HRU heating *)
		IF rTemp>5.0 THEN 																	(* HRU should be running *)
			HRU_Control := RUN ; 
			IF    Supply_Fan_PID.out2>0.0 THEN		HRU_Action := COOLING ;					(* stage2 PID output = HRU in cooling mode *)
			ELSIF Supply_Fan_PID.out4>0.0 THEN		HRU_Action := HEATING ;					(* stage4 PID output = HRU in heating mode *) 
			ELSE									HRU_Action := OFF ;						(* this shouldn't be possible --> check the code ! *)
			END_IF ;
		ELSE 																				(* HRU is off *)
			HRU_Control := STOP ; 					HRU_Action  := OFF ; 
		END_IF ;

		HRU_Efficiency := F_HRU_effectiveness_calculation(T_fresh:=Fresh_Air_Temperature_Measurement, T_return:=Return_Air_Temperature_Measurement, T_exhaust:=Exhaust_Air_Temperature_Measurement) ;

		Fresh_Air_Damper_Control		:= OPEN ;
		Exhaust_Air_Damper_Control		:= OPEN ;

		Calculate_Heating_Valve_Position(PID_value:=Supply_Fan_PID.out5) ;					(* calculate heating coil valve position *)
		Heating_Coil_Valve_Control 		:= Calculate_Heating_Valve_Position.Heating_Coil_Valve_Position ;
		Cooling_Coil_Valve_Control		:= Supply_Fan_PID.out1 ;							(* stage1 output of the PID goes to cooling coild *)
		IF Cooling_Coil_Valve_Control>5.0 THEN Cooling_Coil_Pump_Control:=RUN; ELSE Cooling_Coil_Pump_Control:=STOP; END_IF ;

		iTemp := REAL_TO_INT(Fans_Minimum_Start_Speed) ;
		Return_Air_PID.pband1 			:= 50.0 ; 
		Return_Fan_PID.pband1 			:= 15.0 ; 
		Supply_Fan_PID.pband1 			:= 10.0 ; 		 
		Supply_Fan_PID.pband2 			:= 5.0 ; 
		Supply_Fan_PID.pband3 			:= 2.0 ;  
		Supply_Fan_PID.pband4 			:= 10.0 ;  
		Supply_Fan_PID.pband5 			:= 20.0 ;  

		Supply_Air_Temperature_Calculated_Setpoint := Supply_Air_Temperature_Setpoint_Minimum + (Supply_Air_Temperature_Setpoint_Maximum-Supply_Air_Temperature_Setpoint_Minimum)*Return_Fan_PID.out1/100.0 ;
		
	ELSIF AHU_status=11 THEN																(* manual ON *)
		Supply_Fan_Speed_Control		:= Fans_Minimum_Start_Speed ;
		Return_Fan_Speed_Control		:= Fans_Minimum_Start_Speed ;
		Supply_Fan_Command				:= RUN ;
		Return_Fan_Command				:= RUN ;
		HRU_Control						:= RUN ;
		HRU_Efficiency					:= 0.0 ;
		Fresh_Air_Damper_Control		:= OPEN ;
		Exhaust_Air_Damper_Control		:= OPEN ;
		Heating_Coil_Valve_Control		:= Heating_Coil_Valve_Manual_Control ;
		Cooling_Coil_Valve_Control		:= Cooling_Coil_Valve_Manual_Control ;
		IF Cooling_Coil_Valve_Control>5.0 THEN	
			Cooling_Coil_Pump_Control	:= RUN ;
		ELSE
			Cooling_Coil_Pump_Control	:= STOP ;
		END_IF ;
	ELSIF AHU_status=20 THEN																(* "opening dampers" *)
		Fresh_Air_Damper_Control		:= OPEN ;										
		Exhaust_Air_Damper_Control		:= OPEN ;
	ELSIF AHU_status=21 THEN																(* "fan startup" *)
		Supply_Fan_Command				:= RUN ;
		Return_Fan_Command				:= RUN ;
		Supply_Fan_Speed_Control		:= Fans_Minimum_Start_Speed ;
		Return_Fan_Speed_Control		:= Fans_Minimum_Start_Speed ;
	END_IF ;

	IF AHU_status<>1 AND AHU_status<>20 AND AHU_status<>21 THEN
		Supply_Damper_Opening_Delay_Timer.IN	:= FALSE ;
		Exhaust_Damper_Opening_Delay_Timer.IN	:= FALSE ;
		Supply_Fan_Conflict_Timer.IN			:= FALSE ;
		Return_Fan_Conflict_Timer.IN			:= FALSE ;
	END_IF ;

	AHU_status_old := AHU_status ;															(* save for next itteration *)
END_IF ;																					(* module is starting up, so we don't do anything *)
END_PROGRAM